/*
 * Created on Aug 5, 2003
*/
package Interface;
import Data.*;

import com.jeans.trayicon.*;

import java.util.*;

import java.sql.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.event.*;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.Timer;

/**
 * @author student
 * This class is being used to bring together message ,announcement and availability capability 
 * 
 */
public class Pinboard extends JFrame implements ActionListener {

	public final static int ONE_SECOND = 1000;
	private Timer timer;
	
	
	final static String ME = "Me";
	final static String AVIALABILITY = "Availability";
	final static String MESSAGES = "Messages";
	final static String ANNOUNCEMENTS = "Announcements";
	private static UserData user;

	JTabbedPane tabbedPane = new JTabbedPane();
	/**
	 * This is the constructor for Pinboard.java
	 */
	public Pinboard(UserData user) {
		super();

		//--
		//		Set callback method to send windows messages through Tray Icon library
		// (see WindowsMessageCallback)
		WindowsTrayIcon.setWindowsMessageCallback(new WindowsMessageCallback());

		if (WindowsTrayIcon.isRunning("Pinboard")) {
			System.out.println(
				"Previous Instance is already Running.To create new Instance exit the previous instance.");

			// TestTrayIcon.this instead of this$0 for Java 1.3 compatibility
			WarningBox box = new WarningBox(Pinboard.this);
			centerDialog(box);
			box.setVisible(true);
			return;

		}
		//current user
		this.user = user;
		
		JFrame.setDefaultLookAndFeelDecorated(true);

		//Update  timer display in milliseconds
		ActionListener taskPerformer = new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				SetTitle();
			}
		};
		new Timer(ONE_SECOND, taskPerformer).start();

		this.setSize(600, 400);
		//		this.setLocation(300,150);
		centerDialog(this);
		this.setResizable(false);
		ImageIcon img = new ImageIcon("./Interface/pinboard.gif");
		this.setIconImage(img.getImage());

		Container contentPane = getContentPane();

		contentPane.add(tabbedPane, BorderLayout.CENTER);

		//ME
		 final TabMe me = new TabMe(user);
		System.out.println("TabMe " + user.getLoginId());
		JPanel mePanel = me.createTabMe();
		tabbedPane.addTab(ME, mePanel);

		//ANNOUNCEMENT
		final TabAnnouncement announcement = new TabAnnouncement(user);
		JPanel aPanel = announcement.createTabAnnouncement();
		tabbedPane.addTab(ANNOUNCEMENTS, aPanel);
		//MESSAGES
		final TabMessage message = new TabMessage(user);
		JPanel mPanel = message.createTabMessage();
		tabbedPane.addTab(MESSAGES, mPanel);
		//AVAILABILITY
		final TabAvailability av = new TabAvailability();
		JPanel avPanel = av.createTabAvailability();
		tabbedPane.addTab(AVIALABILITY, avPanel);
		tabbedPane.validate();

		this.setVisible(true);

		tabbedPane.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent evt) {

				System.out.println("State is changed");

				if (tabbedPane
					.getTitleAt(tabbedPane.getSelectedIndex())
					.equals(AVIALABILITY)) {
					av.refresh();
				} else if (
					tabbedPane.getTitleAt(
						tabbedPane.getSelectedIndex()).equals(
						ANNOUNCEMENTS)) {
					announcement.refresh();
				} else if (
					tabbedPane.getTitleAt(
						tabbedPane.getSelectedIndex()).equals(
						MESSAGES)) {
					message.refresh();
				} else if (
					tabbedPane.getTitleAt(
						tabbedPane.getSelectedIndex()).equals(
						ME)) {
				}
			}
		});

		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				//makeIcon();

				//dispose();			
				//System.exit(0);

			}
			public void windowClosed(WindowEvent e) {
			}
			public void windowOpened(WindowEvent e) {
				makeIcon();
				displayMessage("Window opened", e);
			}

			public void windowIconified(WindowEvent e) {
				displayMessage("Window iconified", e);
				//	makeIcon();				
			}

			public void windowDeiconified(WindowEvent e) {
				displayMessage("Window deiconified", e);
			}

			public void windowActivated(WindowEvent e) {
				displayMessage("Window activated", e);
			}

			public void windowDeactivated(WindowEvent e) {
				displayMessage("Window deactivated", e);
			}
		});
	}

	/**
	 * This method is being used to make an application tray icon
	 *  void
	 */
	public void makeIcon() {
		try {
			if (WindowsTrayIcon.isRunning("Pinboard")) {
				//							System.out.println("Previous Instance is already Running.To create new Instance exit the previous instance.");
				//							
				//							// TestTrayIcon.this instead of this$0 for Java 1.3 compatibility
				//							WarningBox box = new WarningBox(Pinboard.this);
				//							centerDialog(box);
				//							box.setVisible(true);
				return;

			}
			WindowsTrayIcon.initTrayIcon("Pinboard");
			System.out.println("making icon");
			ImageIcon imageicon = new ImageIcon("./Interface/pinboard.gif");
			final WindowsTrayIcon icon = new WindowsTrayIcon(imageicon.getImage(), 16, 16);
			icon.setToolTipText("Pinboard");
			icon.setPopup(makePopup());
			icon.addMouseListener(new MouseAdapter() {
				public void mousePressed(MouseEvent evt) {
					if ((evt.getModifiers() & MouseEvent.BUTTON1_MASK) != 0
						&& evt.getClickCount() == 2) {
						icon.addActionListener(new RestoreListener(true));
						System.out.println("[Tray icon double clicked].");
						//icon.addActionListener(new RestoreListener(true));
					}
				}
			});

			icon.setVisible(true);
		} catch (Exception exp) {
		}
	}

	/**
	 * This method is being used to make trayicon popup menu
	 * @return TrayIconPopup
	 */
	public TrayIconPopup makePopup() {
		// Make new popup menu
		TrayIconPopup popup = new TrayIconPopup();
		// Add show, about, separator & exit item
		TrayIconPopupSimpleItem item = new TrayIconPopupSimpleItem("&Show");
		item.setDefault(true);
		// Each menu item can have it's own ActionListener		
		item.addActionListener(new RestoreListener(true));
		popup.addMenuItem(item);
		item = new TrayIconPopupSimpleItem("&About");
		//			item.setDefault(true);		
		// Each menu item can have it's own ActionListener		
		item.addActionListener(new AboutListener());
		popup.addMenuItem(item);

		// Add a separator		
		popup.addMenuItem(new TrayIconPopupSeparator());
		// Add exit item
		item = new TrayIconPopupSimpleItem("E&xit");
		item.addActionListener(new ExitListener());
		popup.addMenuItem(item);
		return popup;
	}

	/**
	 * This method is being used to display window event messages
	 * @param prefix
	 * @param e void
	 */
	void displayMessage(String prefix, WindowEvent e) {
//		System.out.println(prefix + ": " + e.getWindow() + "\n");
	}
	/**
	 * This class is being used to implement trayicon callback
	 * 
	 */
	private class WindowsMessageCallback implements TrayIconCallback {

		public int callback(int param) {
			// Param contains the integer value send with sendWindowsMessage(appName,param)
			System.out.println(
				"[Other instance started (parameter: " + param + ")].");
			setVisible(true);
			toFront();
			requestFocus();

			// Return integer value to other process
			return 4321;
		}
	}
	/**
	 * This class is being used when About is clicked
	 * 
	 */
	//	Callback listener handles about button
	private class AboutListener implements ActionListener {

		public void actionPerformed(ActionEvent evt) {
			System.out.println("[About selected].");
			// TestTrayIcon.this instead of this$0 for Java 1.3 compatibility
			AboutBox box = new AboutBox(Pinboard.this);
			centerDialog(box);
			box.setVisible(true);
		}
	}

	/**
	 * This class is being used when exit is clicked
	 * 
	 */
	//	Callback listener handles exit button / exit popup menu
	private class ExitListener implements ActionListener {

		public void actionPerformed(ActionEvent evt) {
			dispose();
			System.exit(0);
		}
	}
	//	Callback listener handles restore (click left on any icon / show popup menu)
	private class RestoreListener implements ActionListener {

		protected boolean from_menu;

		public RestoreListener(boolean fromMenu) {
			from_menu = fromMenu;
		}

		public void actionPerformed(ActionEvent evt) {
			if (from_menu) {
				setVisible(true);
				toFront();
				requestFocus();
			} else if (evt.getActionCommand().equals("Left")) {
				if (!isVisible()) {
					// Make main window visible if it was hidden
					setVisible(true);
					// Request input focus
					toFront();
					requestFocus();
				} else {
					doHide(false);
				}
			}
		}
		/**
		 * This method is being used for hiding the application  window
		 * @param exitOnFail void
		 */
		public void doHide(boolean exitOnFail) {
			System.out.println("[Hide selected].");

			// Check if there's a Tray Icon visible
			// Hide works only when there's an icon in the system tray
			boolean visible = true;
			//				for (int k = 0; k < 4; k++)  {
			//					if (m_Icon[k].testVisible()) visible = false;
			//				}
			setVisible(visible);
			if (visible == true) {
				System.out.println(
					"[Hide works only when there's an icon in the system tray].");
				if (exitOnFail)
					doExit();
			}
		}
		/**
		 * This method is being used when you want to exit the application
		 *  void
		 */
		public void doExit() {
			System.out.println("[Exit selected / Close requested].");

			// Free all Tray Icon resources - always call this on exit
			WindowsTrayIcon.cleanUp();

			// Exit application
			System.exit(0);
		}
	}
	/**
	 * This method is being used to center the application window
	 * @param frame void
	 */
	//	Center a dialog on screen
	public static void centerDialog(Window frame) {
		Dimension dialogSize = frame.getSize();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		frame.setLocation(
			screenSize.width / 2 - dialogSize.width / 2,
			screenSize.height / 2 - dialogSize.height / 2);
	}
	/**
	* Called when the user presses the start button.
	*/
	public void actionPerformed(ActionEvent evt) {

		timer.start();
	}
	/**
	 * This method is being used display current time in the title of the application frame
	 *  void
	 */
	public void SetTitle() {
		long currentTime = System.currentTimeMillis();
		Timestamp timestamp = new Timestamp(currentTime);
		GregorianCalendar cal = new GregorianCalendar();
		this.setTitle(
			"Pinboard Application                               "
				+ cal.getTime());
	}
}
